<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Event;

/**
 * An event dispatched after task execution has finished.
 *
 * Be it failed or successful execution, this event will get dispatched. The dispatch occurs before the task
 * completion is persisted, so if need be you may change the fail state on the context object to mark task as
 * failed.
 *
 * This event will not be dispatched if the task was cancelled via the TaskStartEvent dispatch.
 */
class TaskFinishedEvent extends TaskEvent
{
    public function isFailed(): bool
    {
        return $this->context->failed();
    }
}
