<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Component;

/**
 * Interface CronTask.
 */
interface CronTaskInterface extends CronTaskBaseInterface
{
    /**
     * The core logic for executing your task.
     *
     * If exception is thrown, task gets disabled and will not be executed again until
     * disabled flag is cleared in the entity.
     *
     * During execution, you may dispatch {@link \Cyber\CronBundle\Event\TaskProgressEvent} to have the progress
     * reflected in the DB.
     *
     * @throws \Exception if any error occurs
     *
     * @return null|string any returned string will be stored as message in task metadata entity
     */
    public function execute(): ?string;
}
