<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Component;

use Symfony\Component\DependencyInjection\Attribute\Autoconfigure;

/**
 * @internal you should implement one of the child interfaces
 */
#[Autoconfigure(tags: ['cyber.cron'])]
interface CronTaskBaseInterface
{
    /**
     * The name of the schedule this task should follow.
     *
     * Valid values are any schedule you have defined in the config
     *
     * @return string
     */
    public function getSchedule(): string;
}
