<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Manager;

use Cyber\CronBundle\Component\CronTaskBaseInterface;
use Cyber\CronBundle\Component\CronTaskInterface;
use LogicException;
use RuntimeException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\BufferedOutput;

class TaskRunner
{
    /**
     * @param CronTaskBaseInterface $task
     *
     * @throws \Exception on error
     *
     * @return null|string
     */
    public function run(CronTaskBaseInterface $task): ?string
    {
        if ($task instanceof CronTaskInterface) {
            return $task->execute();
        }

        if ($task instanceof Command) {
            $output = new BufferedOutput();
            $input  = new ArrayInput([]);
            $input->setInteractive(false);

            $code = $task->run($input, $output);

            if ($code) {
                throw new RuntimeException(\sprintf('Command exited with code: %d\n%s', $code, $output->fetch()));
            }

            return $output->fetch();
        }

        throw new LogicException(\sprintf('Task is neither "%s" nor a symfony command', CronTaskInterface::class));
    }
}
