<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\CronBundle\Command;

use Cyber\CronBundle\Component\CronCommandInterface;
use LogicException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class MockCronCommand extends Command implements CronCommandInterface
{
    public static $defaultName = 'mock:cron:test';

    /**
     * @inheritdoc
     */
    public function getSchedule(): string
    {
        return 'mock_schedule';
    }

    /**
     * @inheritdoc
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        if ($input->isInteractive()) {
            throw new LogicException('Input should not be interactive for cron');
        }

        $output->writeln('Command executed');

        return 0;
    }
}
