<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Manager;

use Cyber\CronBundle\Component\CronTaskBaseInterface;
use Cyber\CronBundle\Entity\CronTaskInfo;

class ScheduleContext
{
    private $task;

    private $meta;

    /** @var bool */
    private $failed = false;

    /**
     * @var \Throwable
     */
    private $failureException;

    public function __construct(CronTaskBaseInterface $task, CronTaskInfo $meta)
    {
        $this->task = $task;
        $this->meta = $meta;
    }

    /**
     * @return CronTaskBaseInterface
     */
    public function getTask(): CronTaskBaseInterface
    {
        return $this->task;
    }

    /**
     * @return CronTaskInfo
     */
    public function getMeta(): CronTaskInfo
    {
        return $this->meta;
    }

    public function failed(): bool
    {
        return $this->failed;
    }

    public function markFailed(\Throwable $ex): void
    {
        $this->failed           = true;
        $this->failureException = $ex;
    }

    public function toFailureException(): \Throwable
    {
        return $this->failureException;
    }
}
