<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\DependencyInjection;

use Cyber\CronBundle\Component\CronTaskBaseInterface;
use Exception;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class CyberCronExtension extends Extension
{
    /**
     * @inheritDoc
     *
     * @throws Exception
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration();
        $config        = $this->processConfiguration($configuration, $configs);

        if(!isset($config['orm'])) {
            // if we don't have orm config, do not load anything.
            // user probably added the bundle but was not ready to configure it yet.
            return;
        }

        $container->registerForAutoconfiguration(CronTaskBaseInterface::class)
            ->addTag('cyber.cron');

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $loader->load('services.yml');

        $container->setAlias('cyber_cron.object_manager', $config['orm']['manager']);
        $container->setParameter('cyber_cron.entity_class', $config['orm']['task_entity_class']);
    }
}
