<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\CronBundle\Manager;

use Cyber\CronBundle\Component\CronTaskInterface;
use Cyber\CronBundle\Entity\CronTaskMeta;
use Cyber\CronBundle\Manager\TaskRegistry;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Mapping\ClassMetadata;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * @covers \Cyber\CronBundle\Manager\TaskRegistry
 *
 * @internal
 */
class TaskRegistryTest extends TestCase
{
    /** @var TaskRegistry */
    private $instance;

    /**
     * @var EntityManagerInterface|MockObject
     */
    private $em;

    public function testAddScheduledTaskClosureAndFindIt(): void
    {
        /** @var CronTaskInterface|MockObject $task */
        $task = $this->getMockBuilder(CronTaskInterface::class)
            ->getMock();

        $this->instance->addScheduledTaskClosure(function () use ($task) {
            return $task;
        });

        $found = $this->instance->findTask(\get_class($task));
        static::assertSame($task, $found);

        $meta = $this->instance->getTaskClassMap();

        static::assertNotEmpty($meta);
    }

    public function testGetRepository(): void
    {
        $repoMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $this->em->expects(static::once())
            ->method('getRepository')
            ->withConsecutive([CronTaskMeta::class])
            ->willReturn($repoMock);

        $repo  = $this->instance->getRepository();
        $repo2 = $this->instance->getRepository();

        static::assertSame($repoMock, $repo);
        static::assertSame($repoMock, $repo2);
    }

    public function testObjectManager(): void
    {
        $em = $this->instance->getObjectManager();

        static::assertSame($this->em, $em);

        $metaMock = $this->getMockBuilder(ClassMetadata::class)->disableOriginalConstructor()->getMock();
        $this->em->expects(static::once())
            ->method('getClassMetadata')
            ->withConsecutive([CronTaskMeta::class])
            ->willReturn($metaMock);

        $meta = $this->instance->getEntityMetadata();
        static::assertSame($metaMock, $meta);
    }

    protected function setUp(): void
    {
        $this->em = $this->getMockBuilder(EntityManagerInterface::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->instance = new TaskRegistry($this->em, CronTaskMeta::class);
    }
}
