<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\CronBundle\Component;

/**
 * This interface allows you turn your existing commands into tasks executed by this bundle.
 *
 * Simply implement this interface in your command, and you are good to go.
 *
 * If exception is thrown or command exists with non-zero code, task gets disabled and will not be executed again until
 * disabled flag is cleared in the entity.
 *
 * During execution, you may dispatch {@link \Cyber\CronBundle\Event\TaskProgressEvent} to have the progress
 * reflected in the DB.
 */
interface CronCommandInterface extends CronTaskBaseInterface
{
}
