<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\CronBundle\EventListener;

use Cyber\CronBundle\Event\TaskProgressEvent;
use Cyber\CronBundle\Manager\TaskRegistry;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Throwable;

class ProgressListener
{
    private $taskRegistry;

    private $logger;

    public function __construct(TaskRegistry $taskRegistry, LoggerInterface $logger = null)
    {
        $this->taskRegistry = $taskRegistry;
        $this->logger       = $logger ?? new NullLogger();
    }

    public function __invoke(TaskProgressEvent $event): void
    {
        $qb = $this->taskRegistry->getRepository()->createQueryBuilder('meta');

        $qb->update()
            ->set('meta.progress', ':progress')
            ->where('meta.serviceId = :className')
            ->setParameter('progress', $event->toProgress() * 100)
            ->setParameter('className', $event->toTaskClass());

        $message = $event->toMessage();
        if ($message) {
            $qb->set('meta.message', ':message')
                ->setParameter('message', $message);
        }

        try {
            $this->logger->debug('Recording progress: ' . $event);

            $qb->getQuery()->execute();
        } catch (Throwable $ex) {
            $this->logger->error('Failed to record task progress: ' . $ex->getMessage(), ['exception' => $ex]);
        }
    }
}
