<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Tests\Cyber\CronBundle\Command;

use Cyber\CronBundle\Component\CronCommandInterface;
use DateTimeImmutable;
use LogicException;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand('mock:cron:test')]
class MockCronCommand extends Command implements CronCommandInterface
{
    /**
     * @inheritDoc
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        if ($input->isInteractive()) {
            throw new LogicException('Input should not be interactive for cron');
        }

        $output->writeln('Command executed');

        return 0;
    }

    public function getNextExecutionTime(DateTimeImmutable $currentStartTime): DateTimeImmutable
    {
        return $currentStartTime->modify('1 minute');
    }
}
