<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\CronBundle\Component;

use DateTimeImmutable;
use Symfony\Component\DependencyInjection\Attribute\Autoconfigure;

/**
 * @internal you should implement one of the child interfaces
 */
#[Autoconfigure(tags: ['cyber.cron'])]
interface CronTaskBaseInterface
{
    /**
     * Called at the end of the current execution to get the time for next one.
     *
     * @param DateTimeImmutable $currentStartTime start time of the current execution
     *
     * @return DateTimeImmutable the time when next execution of this task should be scheduled
     */
    public function getNextExecutionTime(DateTimeImmutable $currentStartTime): DateTimeImmutable;
}
