<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\DependencyInjection\Compiler;

use Cyber\CronBundle\Manager\TaskRegistry;
use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\DependencyInjection\Argument\ServiceClosureArgument;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException;
use Symfony\Component\DependencyInjection\Reference;

class HandlersPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     *
     * @throws ServiceNotFoundException
     * @throws InvalidArgumentException
     * @throws InvalidConfigurationException
     */
    public function process(ContainerBuilder $container): void
    {
        // always first check if the primary service is defined
        if (!$container->has(TaskRegistry::class)) {
            return;
        }

        $registryDef  = $container->findDefinition(TaskRegistry::class);
        $cronHandlers = $container->findTaggedServiceIds('cyber.cron');

        foreach (\array_keys($cronHandlers) as $service) {
            $registryDef->addMethodCall(
                'addScheduledTaskClosure',
                [new ServiceClosureArgument(new Reference($service))]
            );
        }
    }
}
