<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Cyber\CronBundle\Command\CronCommand;
use Cyber\CronBundle\Command\DebugCronCommand;
use Cyber\CronBundle\Command\ListCommand;
use Cyber\CronBundle\Command\SyncMetadataCommand;
use Cyber\CronBundle\Command\TaskCommand;
use Cyber\CronBundle\Command\ValidateCronTasksCommand;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->services()
        ->set('cyber_cron.command.validate', ValidateCronTasksCommand::class)
            ->args([
                service('cyber_cron.task.registry'),
                service('cyber_cron.task.scheduler'),
            ])
            ->tag('console.command')
        ->alias(ValidateCronTasksCommand::class, 'cyber_cron.command.validate')

        ->set('cyber_cron.command.task', TaskCommand::class)
            ->args([
                service('cyber_cron.task.registry'),
            ])
            ->tag('console.command')
        ->alias(TaskCommand::class, 'cyber_cron.command.task')

        ->set('cyber_cron.command.list', ListCommand::class)
            ->args([
                service('cyber_cron.task.registry'),
            ])
            ->tag('console.command')
        ->alias(ListCommand::class, 'cyber_cron.command.list')

        ->set('cyber_cron.command.sync', SyncMetadataCommand::class)
            ->args([
                service('cyber_cron.task.registry'),
            ])
            ->tag('console.command')
        ->alias(SyncMetadataCommand::class, 'cyber_cron.command.sync')

        ->set('cyber_cron.command.run', CronCommand::class)
            ->args([
                service('cyber_cron.task.scheduler'),
                service('event_dispatcher'),
            ])
            ->tag('console.command')
        ->alias(CronCommand::class, 'cyber_cron.command.run')

        ->set('cyber_cron.command.debug', DebugCronCommand::class)
            ->args([
                service('cyber_cron.task.registry'),
            ])
            ->tag('console.command')
        ->alias(DebugCronCommand::class, 'cyber_cron.command.debug');
    // @formatter:on
};
