<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Cyber\CronBundle\EventListener\ProgressListener;
use Cyber\CronBundle\Manager\TaskLocker;
use Cyber\CronBundle\Manager\TaskRegistry;
use Cyber\CronBundle\Manager\TaskScheduler;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->parameters()
        ->set('cyber_cron.entity_class', null);

    $container->services()
        ->set('cyber_cron.task.registry', TaskRegistry::class)
            ->args([
                service('cyber_cron.object_manager'),
                param('cyber_cron.entity_class'),
            ])
        ->alias(TaskRegistry::class, 'cyber_cron.task.registry')

        ->set('cyber_cron.task.locker', TaskLocker::class)
            ->args([
                service('cyber_cron.task.registry'),
            ])
        ->alias(TaskLocker::class, 'cyber_cron.task.locker')

        ->set('cyber_cron.task.scheduler', TaskScheduler::class)
            ->args([
                service('cyber_cron.task.registry'),
                service('cyber_cron.task.locker'),
                service('logger')->nullOnInvalid(),
            ])
            ->tag('monolog.logger', ['channel' => 'cron'])
        ->alias(TaskScheduler::class, 'cyber_cron.task.scheduler')

        ->set('cyber_cron.task.progress_listener', ProgressListener::class)
            ->args([
                service('cyber_cron.task.registry'),
                service('logger')->nullOnInvalid(),
            ])
            ->tag('monolog.logger', ['channel' => 'cron'])
            ->tag('kernel.event_listener');
    // @formatter:on
};
