The metadata entity is used to store the information about tasks managed by this bundle. Ex. */src/Entity/CronMeta.php*

# Entity Examples

Ultimately your entity must extends `Cyber\CronBundle\Entity\CronTaskMetaBase`, however the bundle does come
with a *Mapped Superclass* you can use, if our default mappings work for your project.

## Extending CronTaskMeta

The *Mapped Superclass* is `Cyber\CronBundle\Entity\CronTaskMeta`, if you extend that, you only need to define id field.

```php
<?php
namespace App\Entity;

use Cyber\CronBundle\Entity\CronTaskMeta;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: "cron_task_meta")]
#[ORM\Entity]
class Cron extends CronTaskMeta
{
    #[ORM\Column]
    #[ORM\Id]
    #[ORM\GeneratedValue]
    protected ?int $id;
}
``` 

## Extending CronTaskMetaBase

For a more customized mapping you can extend `Cyber\CronBundle\Entity\CronTaskMetaBase`. You must provide mapping for
all protected fields for scheduler to work.

```php
<?php
namespace App\Entity;

use Cyber\CronBundle\Entity\CronTaskMetaBase;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: "cron_task_meta")]
#[ORM\Entity]
class Cron extends CronTaskMetaBase
{
    #[ORM\Column]
    #[ORM\Id]
    #[ORM\GeneratedValue]
    protected ?int $id;
    
    #[ORM\Column(type: 'datetimetz_immutable', nullable: true)]
    protected ?DateTimeImmutable $lastRun = null;

    #[ORM\Column(type: 'datetimetz_immutable')]
    protected DateTimeImmutable $nextRun;

    #[ORM\Column(type: 'integer', nullable: true)]
    protected ?int $executingPid = null;
    
    // other rest of the protect fields from base class.
}
``` 

# Migration

Once your entity is created, if you are using doctrine migrations you should create a migration for your entity:

```bash
$ php bin\console make:migration
$ php bin\console doctrine:migrations:migrate
```

# Add Config Values

As the last step do not forget to provide the entity class to the bundle via your project config files:

```yml
cyber_cron:
    orm:
        task_entity_class: 'App\Entity\CronMeta'
```
