<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle;

use Cyber\CronBundle\Component\CronTaskBaseInterface;
use Cyber\CronBundle\DependencyInjection\HandlersPass;
use Symfony\Component\Config\Definition\Configurator\DefinitionConfigurator;
use Symfony\Component\Console\Application;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Symfony\Component\HttpKernel\Bundle\AbstractBundle;

class CyberCronBundle extends AbstractBundle
{
    public function configure(DefinitionConfigurator $definition): void
    {
        // @formatter:off
        $definition->rootNode()
            ->children()
                ->arrayNode('orm')
                    ->children()
                        ->scalarNode('manager')
                            ->cannotBeEmpty()
                            ->defaultValue('doctrine.orm.entity_manager')
                        ->end()
                        ->scalarNode('task_entity_class')
                            ->isRequired()
                            ->cannotBeEmpty()
                        ->end()
                    ->end()
                ->end()
            ->end();
        // @formatter:on
    }

    /**
     * @param array{orm?: array<string, string>} $config
     */
    public function loadExtension(array $config, ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        if (!isset($config['orm'])) {
            // if we don't have orm config, do not load anything.
            // user probably added the bundle but was not ready to configure it yet.
            return;
        }

        $builder->registerForAutoconfiguration(CronTaskBaseInterface::class)
            ->addTag('cyber.cron');

        $container->import('../config/services.php');

        if (\class_exists(Application::class)) {
            $container->import('../config/console.php');
        }

        $container->services()->alias('cyber_cron.object_manager', $config['orm']['manager']);
        $container->parameters()->set('cyber_cron.entity_class', $config['orm']['task_entity_class']);
    }

    public function build(ContainerBuilder $container): void
    {
        $container->addCompilerPass(new HandlersPass());
    }
}
