<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\CronBundle\Event;

use Cyber\CronBundle\Component\CronTaskBaseInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event dispatched by task that wish to report their progress.
 */
class TaskProgressEvent extends Event
{
    private $task;

    private $taskClass;

    private $progress;

    private $message;

    public function __construct(CronTaskBaseInterface $task, float $progress, string $message = null)
    {
        $this->task      = $task;
        $this->taskClass = \get_class($task);
        $this->progress  = $progress;
        $this->message   = $message;
    }

    /**
     * @return CronTaskBaseInterface
     */
    public function toTask(): CronTaskBaseInterface
    {
        return $this->task;
    }

    /**
     * @return string
     */
    public function toTaskClass(): string
    {
        return $this->taskClass;
    }

    /**
     * @return float
     */
    public function toProgress(): float
    {
        return $this->progress;
    }

    /**
     * @return null|string
     */
    public function toMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @inheritDoc
     */
    public function __toString()
    {
        return \sprintf('%s %.2f%% %s', $this->taskClass, $this->progress * 100, $this->message);
    }
}
