<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Command;

use Cyber\CronBundle\Manager\TaskRegistry;
use DateTimeImmutable;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(name: 'cyber:cron:validate', description: 'Validates that tasks and configs are correct.')]
class ValidateCronTasksCommand extends Command
{
    public function __construct(private readonly TaskRegistry $taskRegistry)
    {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);
        $io->title('Cyber Cron Task Validation');

        $tasks     = $this->taskRegistry->getTaskClassMap();

        $ref     = new DateTimeImmutable();
        $invalid = [];
        foreach ($tasks as $class => $task) {
            $nextTime = $task->getNextExecutionTime($ref);
            if ($nextTime <= $ref) {
                $invalid[] = $class;
            }
        }

        if (!empty($invalid)) {
            $io->text('<info>The following tasks returned invalid Next Execution Time:</>');
            $io->listing($invalid);
        }

        $io->success('Validation Passed');

        return 0;
    }
}
