# About

Simple task queue with Symfony and Cron daemon.

# Configuration

This bundle uses the following configuration structure. You should configure all options as needed by your project. You
can find this configuration wth the command

```bash
$ php bin/console config:dump-reference cyber_cron
```

```yaml
cyber_cron:
    orm: # Required
        manager: doctrine.orm.entity_manager
        task_entity_class: ~ # Required
```

# DB Storage

Before using any features of the bundle you must setup the entity for database storage of task metadata:

* [Setup Metadata Entity](./metadata-entity.md)

# Defining Tasks

Now you are ready to create your first taks by making a class which implements an appropriate interface.
Currently there are 2 styles of tasks that you can create:

1. Standrd Task - A task which is only executable using console commands provided by this bundle
2. Command As Task - A regular console command which doubles as a cron task

> You can read more about [task definitions here](./defining-tasks.md)

# Bundle Commands

This bundle includes several commands to configure, debug, and run the tasks.

## Task Metadata

Scheduler depends on the metadata entity records to run your tasks. Keep metadata up to date by executing the sync
command whenever you add/remove new tasks:

```bash
$ php bin/console cyber:cron:sync-metadata
```

> this only adds/removes tasks from the store, it does not reset schedules or flags of any existing tasks.

## Testing Cron Task

The debug command provided by this bundle will serve as both validating that your task metadata exist, as well as
perform a test executiong of your task. Simply pass your cron task FQCN as an argument:

```bash
$ php bin/console debug:cyber:cron App\Your\Task\Class
```

# Setup Crontab

As a final step you need to setup the crontab to execute the scheduler. Scheduler should be setup to run every minute:

```bash
* * * * * php bin/console cyber:cron:run > /var/log/cyber-cron.log
```

> The above is extremely condensed example. On your production systems you may need to provide full paths to executables
> and configure proper working directory. Also keep in mind cron might need to execute under user that runs the web
> server behind your application if running on same system, otherwise cache permission conflicts may occur.

## Crontab Schedule

You may choose to configure the scheduler to run as infrequently as your most frequent task.
For example, if all your tasks are set to run once an hour, can change the definition to `0 * * * *`. This would save
on db query which will now run once an hour instead of once per minute.

# Events

CronBundle generates 3 types of events when the task is executed.

* Before Execution
* After successful completion
* After unsuccessful completion

You need to create a listener file (*listener.php) to subscribe to these events:

```php
class YourListener implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            CyberCronEvents::TASK_START    => 'taskStart',
            CyberCronEvents::TASK_FINISHED => 'taskFinished',
            CyberCronEvents::TASK_FAILURE  => 'taskFailure',
        ];
    }

    /**
     * @param CronTaskInfoEvent $event
     */
    public function taskStart(CronTaskInfoEvent $event): void
    {
    }

    /**
     * @param CronTaskInfoEvent $event
     */
    public function taskFinished(CronTaskInfoEvent $event): void
    {
    }

    /**
     * @param CronTaskInfoEvent $event
     */
    public function taskFailure(CronTaskInfoEvent $event): void
    {
    }
}
```

And register it in the configuration file (*.yml):

```yaml
services:
    path\to\file\YourListener:
        tags:
            - { name: kernel.event_subscriber }
```

# Multi Server Environment

This bundle leverages DB for locking purposes. So if 2 servers/processes try to run same task at the same time only one
will succeed. Which means that you can safely run this on any number of servers simultaneously and be sure that tasks
would not get repeated unnecessarily.
