<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Entity;

use DateTimeImmutable;
use Doctrine\ORM\Mapping as ORM;

#[ORM\MappedSuperclass]
class CronTaskMeta extends CronTaskMetaBase
{
    /**
     * @var class-string
     */
    #[ORM\Column(type: 'string', length: 100, unique: true)]
    protected string $serviceId;

    #[ORM\Column(type: 'datetimetz_immutable', nullable: true)]
    protected ?DateTimeImmutable $lastRun = null;

    #[ORM\Column(type: 'datetimetz_immutable')]
    protected DateTimeImmutable $nextRun;

    #[ORM\Column(type: 'integer', nullable: true)]
    protected ?int $executingPid = null;

    #[ORM\Column(type: 'boolean', options: ['default' => false])]
    protected bool $isDisabled = false;

    #[ORM\Column(type:'text')]
    protected string $message = '';

    #[ORM\Column(type: 'float')]
    protected float $progress = 0;

    /**
     * @inheritDoc
     */
    public function getServiceId(): string
    {
        return $this->serviceId;
    }

    /**
     * @inheritDoc
     */
    public function setServiceId(string $serviceId): self
    {
        $this->serviceId = $serviceId;

        return $this;
    }
}
