<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Event;

/**
 * This even is dispatched right before the task execution begins.
 *
 * You may cancel the current execution by calling the cancel() method.
 * Completion event will not get dispatched if task was cancelled this way.
 */
class TaskStartEvent extends TaskEvent
{
    /** @var bool */
    private $cancelled = false;

    public function cancel(): void
    {
        $this->cancelled = true;
    }

    public function isCancelled(): bool
    {
        return $this->cancelled;
    }
}
