<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle;

class LogTaggingProcessor
{
    /**
     * @var array<mixed>
     */
    private $tags;

    /**
     * @param mixed $tags
     */
    public function __construct($tags)
    {
        $this->tags = (array) $tags;
    }

    /**
     * @param array<mixed> $record
     *
     * @return array<mixed>
     *
     * @noinspection AdditionOperationOnArraysInspection
     */
    public function processRecord(array $record): array
    {
        $record['extra'] += $this->tags;

        return $record;
    }
}
