Makes fixtures usable not only for development, but also for static data provisioning and new system deployments. 

## Configuration
```yaml
cyber_deployment:
    fixtures:
        standard:   true
        install:    src/AppBundle/DataFixtures/Install
        dev:        src/AppBundle/DataFixtures/Dev
```

The **standard** configuration indicates if standard data fixtures should be enabled an used. These are the fixtures.
The other 2 options need to specify path that would get accepted by `--fixtures` argument of `doctrine:fixtures:load`
command (if path is null the corresponding fixture type is disabled).

## Usage
```bash
> php bin/console cyber:deploy:fixtures [--dev|--install]
```

Running this command will always *append* standard features if they are enabled. Further more if ran with `--install` or
`--dev` flag additional fixtures will be applied.

* `--install` - *appends* `install` fixtures after standard ones
* `--dev` - resets database schema, applies standard, install, and dev fixtures
    * DO NOT RUN THIS ON LIVE DATABASE CONNECTION

## Install Fixtures
Intended to be ran only once during new live system setup. These fixtures are intended to create some initial
configuration which can then be used to fully configure the application.

Most basic example is to create a `root` user account with known password, when deploying a new application. Then
login with that account, reset password and create additional admin and user accounts. 

These are typically ran manually by the individual deploying the new live environment. 

## Standard Fixtures
These are intended to maintain managed data in the database. This fixtures are expected to execute during each
deployment and should be written in a way to append data to tables if it is missing and remove stuff that is not needed.

These could be used to maintain application specific enum lists that is not editable by users but should still be
available for convenient database queries (language abbreviation -> language name). 

Typical implementation of such fixtures includes a data array and a loop that checks data existence. Then update existing
and create any missing records.

> Entities of these fixtures typically do not have auto-generated ID, instead it is manually assigned by fixture itself 

```php
<?php

private $languages = [
    'en' => 'English',
    'aa' => 'Afar',
];

public function load(ObjectManager $manager)
{
    
    foreach ($this->languages as $code => $name) {
        $entity = $manager->find("CoreAppBundle:Language", $code);
        if ($entity == null) {
            $entity = new Language();
            $entity->setCode($code);
            $manager->persist($entity);
        }
        $entity->setName($name);
    }

    $manager->flush();
}
```

## Dev Fixtures
These are the fixtures that you are probably most familiar with. They load fake data into database so that developers
don't have to work with empty database every time they need to reset the schema.

They are applied only command is ran with `--dev` flag.
