<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\DeploymentBundle;

use Cyber\DeploymentBundle\LogTaggingProcessor;
use Monolog\Logger;
use PHPUnit\Framework\TestCase;

class LogTaggingProcessorTest extends TestCase
{
    /** @var LogTaggingProcessor */
    private $processor;

    /**
     * {@inheritdoc}
     */
    protected function setUp(): void
    {
        $this->processor = new LogTaggingProcessor(['graylog_tag' => 'dev', 'graylog_site' => 'cyber-collection']);
    }

    public function testProcessRecord(): void
    {
        $record = $this->processor->processRecord(['extra' => []]);
        $this->assertEquals(['extra' => ['graylog_tag' => 'dev', 'graylog_site' => 'cyber-collection']], $record);

        // processor should not override a tag if one already exists
        $record = $this->processor->processRecord(['extra' => ['graylog_tag' => 'test-override']]);
        $this->assertEquals(
            ['extra' => ['graylog_tag' => 'test-override', 'graylog_site' => 'cyber-collection']],
            $record
        );
    }

    /**
     * @group integration
     */
    public function testWithRealLogger(): void
    {
        $logger = new Logger('my_channel', [], [[$this->processor, 'processRecord']]);

        $result = $logger->info('some message');

        $this->assertTrue($result);
    }
}
