<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\DeploymentBundle\DependencyInjection;

use Cyber\DeploymentBundle\DependencyInjection\CyberDeploymentExtension;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class CyberDeploymentExtensionTest extends TestCase
{
    /** @var ContainerBuilder */
    private $container;

    /**
     * @inheritdoc
     */
    protected function setUp(): void
    {
        $this->container = new ContainerBuilder();
    }

    public function testLoggerTaggingServiceExists(): void
    {
        $extension = new CyberDeploymentExtension();
        $extension->load([
            'cyber_deployment' => [
                'log_tagging' => [
                    'tags' => [
                        'sometag' => 'some_value',
                    ],
                ],
            ],
        ], $this->container);

        $this->assertTrue($this->container->has('Cyber\DeploymentBundle\LogTaggingProcessor'));
    }

    public function testFixtureParams(): void
    {
        $extension = new CyberDeploymentExtension();
        $extension->load([
            'cyber_deployment' => [
                'fixtures' => [
                    'standard' => true,
                    'install'  => false,
                    'dev'      => true,
                ],
            ],
        ], $this->container);

        $this->assertTrue($this->container->getParameter('cyber.deployment.fixture.standard'));
        $this->assertFalse($this->container->getParameter('cyber.deployment.fixture.install'));
        $this->assertTrue($this->container->getParameter('cyber.deployment.fixture.dev'));
    }
}
