<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\DeploymentBundle\Migrations;

use Cyber\DeploymentBundle\Migrations\FunctionExtractor;
use PHPUnit\Framework\TestCase;

/**
 * @covers \Cyber\DeploymentBundle\Migrations\FunctionExtractor
 */
class FunctionExtractorTest extends TestCase
{
    public function testGetFunctionData(): void
    {
        $code = <<<EOC
function x()
{
    // some code
}
EOC;

        $instance = new FunctionExtractor($code);

        $data = $instance->getFunctionData(0);
        $this->assertEquals('
    // some code', $data);
    }

    public function testNoFunction(): void
    {
        $this->expectException(\UnexpectedValueException::class);
        $this->expectExceptionMessage('Failed to find start of function');

        $code = <<<EOC
function x()

    // some code
}
EOC;

        $instance = new FunctionExtractor($code);

        $instance->getFunctionData(0);
    }

    public function testNoEndOfFunction(): void
    {
        $this->expectException(\UnexpectedValueException::class);
        $this->expectExceptionMessage('Failed to find end of function');

        $code = <<<EOC
function x()
{
    // some code
    {
    
}
EOC;

        $instance = new FunctionExtractor($code);

        $instance->getFunctionData(0);
    }
}
