A command that allows to consolidate many dev migrations into one for release, and also check best practices while it's
at it.

## Configuration
For this command to work you need to provide 2 configuration values to indicate where the `dev` and `prod` migrations 
reside in your application.

```yaml
cyber_deployment:
    migrations:
        dev:    "%kernel.project_dir%/migrations/dev"
        prod:   "%kernel.project_dir%/migrations/prod"
```

> If you have existing migrations that you don't want to consolidate manually, you should move them to `prod` directory
> directly.

Typically this is accompanied by doctrine migrations config that tells migrations bundle to look for migrations in
dir based on `--env`

```yaml
doctrine_migrations:
    dir_name: "%kernel.project_dir%/migrations/%kernel.environment%"
```

## Usage

For regular developer there is no change in procedure, they just generate migrations using the `diff` command. Since
it defaults to `dev` environment, all their migrations will go into `dev` directory.

Prior to release branch creation a responsible individual should run the following command to merge the migrations:

```bash
> php bin/console cyber:deploy:merge-migrations
```

> that will create a new migration in `prod` location and move all version directly in `dev` directory to a sub-directory
> with same name as the `prod` migration.

> DON'T FORGET TO ADD TO GIT AND COMMIT THE **MOVED VERSIONS** AND THE **PROD VERSION**

Assuming you configured your migration `dir_name` based on `%kernel.environment%`, in your deployment script ensure that
migrations run with `prod` environment:

```bash
> php bin/console doctrine:migrations:migrate -n --env=prod
```

## Benefits
A long running feature may introduce a migration that get's applied out of sequence causing failure on production.
Since the merge command creates a new migration of all pending dev version, it ensure better sequencing and such
failures would be detected when [schema validation](./schema-validation.md) is preformed on prod migrations prior to 
release. Without this the only way to detect such failure would be to apply the migration to actual database (be it
staging on live), which will cause unnecessary waste of time for schema recovery.

> Scenario:
> 
> 1. User A and B are working on 2 independent features that happen to in some way relate to same column.
> 2. User A creates a migration v1 that performs `UPDATE x INNER JOIN y SET x.a = y.b`.
> 3. User B creates a migration v2 that renames the column `y.b` to `y.c`
> 
> If we run migrations all together they will pass because v1 is always executed before v2. But say User B finishes the
> feature 1 sprint earlier than user A. In this case migration v2 will go to live before v1 (as v1 is still in progress
> and will only get released the next sprint). 
> 
> For developers all migrations still remain executing successfully but in live systems it will so happen that v2 gets
> executed before v1 since it was published earlier. So when v1 finally gets executed on live it will fail because 
> column `y.b` no longer exists in the database.   

------------------------

Fewer migrations! Since there will be only one migration per release, it would significantly reduce the amount of 
migrations that need to be tracked for prod. At any time the `dev` migrations can be deleted and replaced with 
consolidated `prod` migrations, thus keeping the dev environment in a much cleaner state. 

## Best Practices

1. Warns if your migration depends on external classes which is not allowed per [Policies and Procedures][migration restriction].
2. Warns if your migration uses database connection directly 
    * such migrations should be strictly review, and connection use should be warranted


## Advanced Usage
### Categories
Additionally you can provide a list of categories for your migrations.

```yaml
cyber_deployment:
    migrations:
        dev:    "%kernel.project_dir%/migrations/dev"
        prod:   "%kernel.project_dir%/migrations/prod"
        categories: [preDeploy, postDeploy]
```

If categories are specified the merge command will search for migrations inside the `[dev path]/[category]` instead of
`[dev path]`; and wll generate a merged migration in `[prod]/[category]`. So you will end up with one migration per 
category.

This is designed, as the configuration may hint to you, for splitting pre and post deployment migrations for 
[no downtime migration approach](./no-downtime-migrations.md)

[migration restriction]: https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/Migration-And-Fixture-Workflow.md#restrictions

