<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * An event trigger by fixtures command after database reset and before fixtures are applied.
 *
 * You can use this to perform any extra configurations necessary to bring the db to a proper state.
 */
class PostDatabaseResetEvent extends Event
{
    private string $entityManagerName;

    private ?string $abortMessage = null;

    /**
     * @param string $entityManagerName
     */
    public function __construct(string $entityManagerName)
    {
        $this->entityManagerName = $entityManagerName;
    }

    /**
     * @return string the name of entity manager whose database is being reset
     */
    public function getManagerName(): string
    {
        return $this->entityManagerName;
    }

    /**
     * You can call this to abort execution of the command.
     *
     * @param string $message message to echo to the user running the command
     */
    public function abort(string $message): void
    {
        $this->abortMessage = $message;
    }

    public function isAborted(): bool
    {
        return null !== $this->abortMessage;
    }

    public function getMessage(): ?string
    {
        return $this->abortMessage;
    }
}
