<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\Migrations;

class VersionData
{
    /**
     * @var array<string, bool>
     */
    private $imports = [];

    /**
     * @var array<string, bool>
     */
    private $traits = [];

    /**
     * @var array<string, string>
     */
    private $constants = [];

    /** @var array<string, array<string, string>> */
    private $functions = [];

    /** @var MergeErrors */
    private $errors;

    public function __construct()
    {
        $this->errors = new MergeErrors();
    }

    public function toErrors(): MergeErrors
    {
        return $this->errors;
    }

    public function addImport(string $import): void
    {
        $this->imports[$import] = true;
    }

    /**
     * @return string[]
     */
    public function listImports(): array
    {
        return \array_keys($this->imports);
    }

    public function addTrait(string $trait): void
    {
        $this->traits[$trait] = true;
    }

    /**
     * @return string[]
     */
    public function listTraits(): array
    {
        return \array_keys($this->traits);
    }

    public function addConst(string $name, string $value): void
    {
        if (isset($this->constants[$name])) {
            $this->errors->addError('Same constant name defined in multiple migrations: ' . $name);

            return;
        }

        $this->constants[$name] = '    const ' . $name . ' = ' . $value . ';';
    }

    /**
     * @return string[]
     */
    public function listConstants(): array
    {
        return $this->constants;
    }

    public function addVersionFunctions(string $version, string $upData, string $downData): void
    {
        $this->functions[$version] = [
            'up'   => $upData,
            'down' => $downData,
        ];
    }

    /**
     * @return array<string, array<string, string>>
     */
    public function &listVersionFunctions(): array
    {
        return $this->functions;
    }

    public function isValid(): bool
    {
        return 0 === $this->errors->count();
    }
}
