<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\Migrations;

class MergeErrors
{
    /** @var string[] */
    private $errors = [];

    public function addError(string $message): self
    {
        $this->errors[] = $message;

        return $this;
    }

    /**
     * @return string[]
     */
    public function listErrors(): array
    {
        return $this->errors;
    }

    public function count(): int
    {
        return \count($this->errors);
    }
}
