Makes fixtures usable not only for development, but also for static data provisioning and new system deployments. 

## Configuration
```yaml
cyber_deployment:
    fixtures:
        standard:   true # or false
        install:    true # or false
        dev:        true # or false
        connections:
            - default
            - second
        managers:
            - default
            - second_em
```

This command expects you to assign your fixtures to one of 3 groups `standard`, `install` or `dev` and indicate if you
will you using each of those groups by setting corresponding config value to true or false.

> Read about the recommended new fixture process using [Unified Fixtures](./unified-fixtures.md)

These groups of fixtures will execute based on the arguments passwed to this command.

## Usage
```bash
> php bin/console cyber:deploy:fixtures [--dev|--install]
```

Running this command will always *append* standard features if they are enabled. Further more if ran with `--install` or
`--dev` flag additional fixtures will be applied.

* `--install` - *appends* fixtures with `install` group after standard ones
* `--dev` - **resets database schema**, applies standard, install, and finally fixtures with `dev` group
    * DO NOT RUN THIS ON LIVE DATABASE CONNECTION

## Install Fixtures
Intended to be ran only once during new live system setup. These fixtures are intended to create some initial
configuration which can then be used to fully configure the application.

Most basic example is to create a `root` user account with known password, when deploying a new application. Then
login with that account, reset password and create additional admin and user accounts. 

These are typically ran manually by the individual deploying the new live environment. 

## Standard Fixtures
These are intended to maintain managed data in the database. This fixtures are expected to execute during each
deployment and should be written in a way to append data to tables if it is missing and remove stuff that is not needed.

These could be used to maintain application specific enum lists that is not editable by users but should still be
available for convenient database queries (language abbreviation -> language name). 

Typical implementation of such fixtures includes a data array and a loop that checks data existence. Then update existing
and create any missing records.

> Entities of these fixtures typically do not have auto-generated ID, instead it is manually assigned by fixture itself 

```php
<?php

private $languages = [
    'en' => 'English',
    'aa' => 'Afar',
];

public function load(ObjectManager $manager)
{
    
    foreach ($this->languages as $code => $name) {
        $entity = $manager->find("CoreAppBundle:Language", $code);
        if ($entity == null) {
            $entity = new Language();
            $entity->setCode($code);
            $manager->persist($entity);
        }
        $entity->setName($name);
    }

    $manager->flush();
}
```

## Dev Fixtures
These are the fixtures that you are probably most familiar with. They load fake data into database so that developers
don't have to work with empty database every time they need to reset the schema.

They are applied only command is ran with `--dev` flag.

## Multiplle Connections and EMs
> The only affects the execution with `--dev` flags. 

By default when database and schema is being reset, only the default connection and entity manager are being used.
If your application has multiple connections and EMs AND your `dev` fixtures load data into both, you will need
to specify them in the corresponding config array. 

Database will be dropped and created from scrach for all listed connections/ems when running the command with `--dev`.
