<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\Event;

use Symfony\Contracts\EventDispatcher\Event;

abstract class AbstractDatabaseEvent extends Event
{
    private string $entityManagerName;

    /** @var string[] */
    private array $messages = [];

    private bool $abortExecution = false;

    /**
     * @param string $entityManagerName
     */
    public function __construct(string $entityManagerName)
    {
        $this->entityManagerName = $entityManagerName;
    }

    /**
     * @return string the name of entity manager whose database is being reset
     */
    public function getManagerName(): string
    {
        return $this->entityManagerName;
    }

    /**
     * You can call this to abort execution of the command.
     *
     * @param string $message message to echo to the user running the command
     */
    public function abort(string $message): void
    {
        \array_unshift($this->messages, $message);
        $this->abortExecution = true;
        $this->stopPropagation();
    }

    public function isAborted(): bool
    {
        return $this->abortExecution;
    }

    public function getMessage(): ?string
    {
        return $this->messages[0] ?? null;
    }

    /**
     * @return string[] list of accumulated messages
     */
    public function getMessages(): array
    {
        return $this->messages;
    }

    public function addNote(string $note): void
    {
        $this->messages[] = $note;
    }
}
