<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\Migrations;

use Exception;

class MergeMigrationException extends Exception
{
    /** @var MergeErrors */
    private $errors;

    /**
     * @param MergeErrors $errors
     */
    public function __construct(MergeErrors $errors)
    {
        parent::__construct('Errors during migration merge');

        $this->errors = $errors;
    }

    public function toErrors(): MergeErrors
    {
        return $this->errors;
    }
}
