# Definitions
<dl>
  <dt>Pre-Deploy Migrations</dt>
  <dd>Migrations that get executed before code deployment.</dd>

  <dt>Post-Deploy</dt>
  <dd>Migrations that get executed some time after code deployment. Typically by a cron task</dd>
</dl>

# Configuration
In order to use these commands you need to specify the location of your *preDeploy* and *postDeploy* migrations.

```yaml
cyber_deployment:
    migrations:
        no_downtime:
            pre_deploy: '%kernel.project_dir%/migrations/preDeploy'
            post_deploy: '%kernel.project_dir%/migrations/postDeploy'
            
# with above configuration you should also have your doctrine migrations configured as follows
doctrine_migrations:
    dir_name: '%kernel.project_dir%/migrations'
    # this will allow doctrine_migrations to see both pre and post deploy migrations which is required for no downtime 
    # to work properly 
```

# Workflow

1. Create migrations
    * Carefully split queries into *pre* and *post* deploy migrations. 
        * Move migration files to proper corresponding directories.
2. Before release update the *sequence file* using corresponding command.
3. Deploy live
    1. Run *pre deploy* migrations
    2. Deploy update code
    3. Deffer *post deploy* migrations to a cron job

## Multi Server Considerations
If you are deploying to a stack of servers, since migrations only need to run once, they would run only on leader
server. While migrations are running on leader the rest of servers (which skipped execution of migrations) may finish
deploying new code and go live. If this happens before the leader completes the migrations (because sometimes migrations
could take some time, even if they are of no-downtime type) it will cause issues. 

As such you should try to do:
1. deploy the code to single server first
2. wait for migrations to finish
3. deploy the rest of the servers 

> NOTE about AWS: The only way to do this on AWS at the moment is to set deployment strategy to single server. Which 
> essentially means it will deploy one server at a time. Which is mostly fine as typically there are no more than 4 
> servers up at a time.

# Sequence File

The sequence file is used to tag the latest migration version for each release and associate all *post deploy*
migrations with that latest version. In case if application is migrating multiple tagged version, it ensures
that *post deploy* migrations of previous versions are executed prior to executing the latest *pre deploy*
migration.

The sequence file is generated inside the directory configured via `post_deploy`. You should commit your file
with the migrations.

> Post deploy migration versions must be greater than the version they are tagged under. If you are not using
> migration merging provided by this bundle you may have to rename your *post deploy* migrations prior to updating
> the sequence file.

# Commands
This bundle provides the following commands to assist with managing your post deploy migrations.

> Once you start using no downtime migrations, you should not use `doctrine:migrations:migrate` during live deployment;
> this command should still work as before, and can be safely used by devs to apply all migrations locally.

## Update Command

```bash
> php bin/console cyber:no-downtime:update
```
This command scans the list of your pre and post deploy migrations, compares them to sequence file, and if no issues
found updates the sequence file with new versions.

You should execute this command when creating your release branch and commit the updated sequence file. 

> This assumes your workflow forbids adding migrations in the release branch. If a new migration needs to be added in 
> the release branch, however, you should remove the last entry of the sequence file and run this command again.

## Execute commands 

```bash
> php bin/console cyber:no-downtime:execute [--pre|--post]
```

This command checks your applications current database version and compares it to the sequence file. It determines the
versions that still need to be executed and applies them.

The `--pre` option tells the command to executes *pre-deploy* migrations up until latest version. This typically gets
executed right before your new code becomes active during dpeloyment. 

If Current version is more than one sequences behind, the execution will stop as it is now required to execute both
*pre* and *post* deploy migrations of previous sequences. You can force such execution by passing `--force` flag.

> In short if this command executes successfully with `--pre` flag, you are guaranteed to have all migrations, except the
> post-deploy ones from the latest sequence, to have been applied.

The `--post` option tells the command to execute all missing migrations until the latest *post-deploy* version.
Typically you would schedule this to run in a cron task which should execute after the code changes have been applied.
 
## What's Next

* [Writing Migrations For No Downtime](migration-helpers.md)
