A simple command to replace values in `app/config/parameters.yml` file at runtime. 

This is mainly intended for CI purposes. Instead of maintaining extra config files for various builds it is possible to
simply set the required parameter on per job basis. This is especially useful when the parameter may need to be 
dynamically generated based on the job.

 ```bash
 > php bin/console cyber:deploy:param "param_name" "param_value"
 ```
 
 ## CI
 
 An active use case is for review apps: All review apps run on same web server and use same database server, so the
 database name must be uniquely configured for each review app.
 
```yaml
script:
    - DB_NAME=summit_dyn_$(printf '%s' $CI_COMMIT_REF_NAME | md5sum | cut -d' ' -f1)
    - php bin/console cyber:deploy:param "database_name" "$DB_NAME"
```
