<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\DeploymentBundle\Command;

use Cyber\DeploymentBundle\Command\AppCommandInvoker;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Process\Process;

class MockAppCommandInvoker extends Command
{
    use AppCommandInvoker;

    private Process $processMock;

    private $buildProcCallback;

    public function __construct(Process $processMock, callable $buildProcCallback)
    {
        parent::__construct();

        $this->processMock       = $processMock;
        $this->buildProcCallback = $buildProcCallback;
    }

    /**
     * @param string            $commandName
     * @param array<int|string> $args
     *
     * @return Process
     */
    protected function buildProcess(string $commandName, array $args): Process
    {
        $func = $this->buildProcCallback;
        $func($commandName, $args);

        return $this->processMock;
    }
}
