<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @inheritdoc
     *
     * @noinspection NullPointerExceptionInspection
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('cyber_deployment');

        /** @var ArrayNodeDefinition $rootNode */
        $rootNode = $treeBuilder->getRootNode();

        // @formatter:off
        $rootNode
            ->children()
                ->arrayNode('fixtures')->info('Affects how Fixture command works. All paths should be relative to %kernel.project_dir%')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->arrayNode('connections')->prototype('scalar')->info('List of connection names to manage')->end()->end()
                        ->arrayNode('managers')->prototype('scalar')->info('list of entity manager names to manage')->end()->end()
                        ->scalarNode('migration_table')->info('name of migration table, required for validation command')->end()
                    ->end()
                ->end()
                ->arrayNode('migrations')->info('Configuration for merging migrations')
                    ->children()
                        ->scalarNode('dev')->isRequired()->cannotBeEmpty()->info('Path dev migrations to be merged')->end()
                        ->scalarNode('prod')->isRequired()->cannotBeEmpty()->info('Path where to put the merged migration')->end()
                        ->arrayNode('categories')->prototype('scalar')->info('If configured, the commands will look for migrations inside sub-directories with these names instead of "dev" and "prod" directories directly.')->end()->end()
                        ->arrayNode('no_downtime')->info('Configurations for no-downtime migrations')->canBeEnabled()
                            ->children()
                                ->scalarNode('pre_deploy')->isRequired()->info('Path where pre-deployment migrations are located for prod')->end()
                                ->scalarNode('post_deploy')->isRequired()->info('Path where post-deployment migrations are located for prod')->end()
                            ->end()
                        ->end()

                        ->scalarNode('post_deploy_config')->defaultNull()->info('Path to yml file containing doctrine_migrations conf for postDeploy migration storage.')->end()
                    ->end()
                ->end()
                ->arrayNode('log_tagging')->info('Enables adding of tags to all log messages')
                    ->children()
                        ->arrayNode('tags')->info('Key value pairs to be added to logger message "extra" attribute')
                            ->prototype('scalar')
                        ->end()
                    ->end()
                ->end()
            ->end();

        //@formatter:on

        return $treeBuilder;
    }
}
