<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class CyberDeploymentExtension extends Extension
{
    /**
     * @inheritdoc
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration();
        $config        = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $loader->load('services.yml');

        $this->processFixtures($config['fixtures'], $container);
        if (isset($config['migrations'])) {
            $this->processMigrations($config['migrations'], $container);
        }

        if (isset($config['log_tagging'], $config['log_tagging']['tags'])) {
            $loader->load('log_tagging.yml');
            $container->setParameter('cyber.deployment.log.tags', $config['log_tagging']['tags']);
        }
    }

    /**
     * @param array<mixed>     $config
     * @param ContainerBuilder $container
     */
    private function processMigrations(array $config, ContainerBuilder $container): void
    {
        $confDef = $container->getDefinition(\Cyber\DeploymentBundle\Configuration::class);

        $confDef->addMethodCall('setMigrationDevPath', [$config['dev']]);
        $confDef->addMethodCall('setMigrationProdPath', [$config['prod']]);
        $confDef->addMethodCall('setMigrationCategories', [$config['categories'] ?? []]);

        if ($config['no_downtime']['enabled']) {
            $this->processNoDowntimeConfig($config['no_downtime'], $container);
        }
    }

    /**
     * @param array<mixed>     $config
     * @param ContainerBuilder $container
     */
    private function processNoDowntimeConfig($config, ContainerBuilder $container): void
    {
        $confDef = $container->getDefinition(\Cyber\DeploymentBundle\Configuration::class);

        $confDef->addMethodCall('setPreDeployPath', [$config['pre_deploy']]);
        $confDef->addMethodCall('setPostDeployPath', [$config['post_deploy']]);
    }

    /**
     * @param array<mixed>     $config
     * @param ContainerBuilder $container
     */
    private function processFixtures($config, ContainerBuilder $container): void
    {
        $confDef = $container->getDefinition(\Cyber\DeploymentBundle\Configuration::class);

        if (isset($config['connections'])) {
            $confDef->addMethodCall('setFixtureConnections', [$config['connections']]);
        }

        if (isset($config['managers'])) {
            $confDef->addMethodCall('setFixtureManagers', [$config['managers']]);
        }

        $confDef->addMethodCall('setMigrationTable', [$config['migration_table'] ?? null]);
    }
}
