<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * This event is triggered after all the fixtures have been applied.
 *
 * It includes a list of fixture groups that have been executed.
 */
class FixturesAppliedEvent extends Event
{
    /**
     * @var string[]
     */
    private array $groups;

    /**
     * @param string[] $groups
     */
    public function __construct(array $groups)
    {
        $this->groups = $groups;
    }

    /**
     * @return string[]
     */
    public function getGroups(): array
    {
        return $this->groups;
    }
}
