<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\DeploymentBundle\DependencyInjection;

use Cyber\DeploymentBundle\Configuration;
use Cyber\DeploymentBundle\DependencyInjection\CyberDeploymentExtension;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class CyberDeploymentExtensionTest extends TestCase
{
    /** @var ContainerBuilder */
    private $container;

    /**
     * @inheritdoc
     */
    protected function setUp(): void
    {
        $this->container = new ContainerBuilder();
    }

    public function testLoggerTaggingServiceExists(): void
    {
        $extension = new CyberDeploymentExtension();
        $extension->load([
            'cyber_deployment' => [
                'log_tagging' => [
                    'tags' => [
                        'sometag' => 'some_value',
                    ],
                ],
            ],
        ], $this->container);

        /** @var bool $serviceExists stan thinkgs this is false */
        $serviceExists = $this->container->has('Cyber\DeploymentBundle\LogTaggingProcessor');
        $this->assertTrue($serviceExists);
    }

    public function testFixtureParams(): void
    {
        $extension = new CyberDeploymentExtension();
        $extension->load([
            'cyber_deployment' => [
                'fixtures' => [
                    'connections'          => ['a'],
                    'managers'             => ['b'],
                    'migration_table'      => 'c',
                ],
            ],
        ], $this->container);
        $def = $this->container->getDefinition(Configuration::class);
        static::assertTrue($def->hasMethodCall('setFixtureConnections'));
        static::assertTrue($def->hasMethodCall('setFixtureManagers'));
        static::assertTrue($def->hasMethodCall('setMigrationTable'));
    }
}
