<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle;

class Configuration
{
    /** @var string[] */
    private array $fixtureConnections = [];

    /** @var string[] */
    private array $fixtureManagers = [];

    private ?string $preDeployPath = null;

    private ?string $postDeployPath = null;

    private ?string $migrationDevPath = null;

    private ?string $migrationProdPath = null;

    /** @var string[] */
    private array $migrationCategories = [];

    private ?string $migrationTable = null;

    /**
     * @return string[]
     */
    public function getFixtureConnections(): array
    {
        return $this->fixtureConnections;
    }

    /**
     * @param string[] $fixtureConnections
     *
     * @return $this
     */
    public function setFixtureConnections(array $fixtureConnections): self
    {
        $this->fixtureConnections = $fixtureConnections;

        return $this;
    }

    /**
     * @return string[]
     */
    public function getFixtureManagers(): array
    {
        return $this->fixtureManagers;
    }

    /**
     * @param string[] $fixtureManagers
     *
     * @return $this
     */
    public function setFixtureManagers(array $fixtureManagers): self
    {
        $this->fixtureManagers = $fixtureManagers;

        return $this;
    }

    public function getPreDeployPath(): ?string
    {
        return $this->preDeployPath;
    }

    public function setPreDeployPath(?string $preDeployPath): self
    {
        $this->preDeployPath = $preDeployPath;

        return $this;
    }

    public function getPostDeployPath(): ?string
    {
        return $this->postDeployPath;
    }

    public function setPostDeployPath(?string $postDeployPath): self
    {
        $this->postDeployPath = $postDeployPath;

        return $this;
    }

    public function getMigrationDevPath(): ?string
    {
        return $this->migrationDevPath;
    }

    public function setMigrationDevPath(?string $migrationDevPath): self
    {
        $this->migrationDevPath = $migrationDevPath;

        return $this;
    }

    public function getMigrationProdPath(): ?string
    {
        return $this->migrationProdPath;
    }

    public function setMigrationProdPath(?string $migrationProdPath): self
    {
        $this->migrationProdPath = $migrationProdPath;

        return $this;
    }

    /**
     * @return string[]
     */
    public function getMigrationCategories(): array
    {
        return $this->migrationCategories;
    }

    /**
     * @param string[] $migrationCategories
     *
     * @return $this
     */
    public function setMigrationCategories(array $migrationCategories): self
    {
        $this->migrationCategories = $migrationCategories;

        return $this;
    }

    public function getMigrationTable(): ?string
    {
        return $this->migrationTable;
    }

    public function setMigrationTable(?string $migrationTable): self
    {
        $this->migrationTable = $migrationTable;

        return $this;
    }
}
