<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle;

use Monolog\LogRecord;

class LogTaggingProcessor
{
    /**
     * @var array<mixed>
     */
    private $tags;

    /**
     * @param mixed $tags
     */
    public function __construct($tags)
    {
        $this->tags = (array) $tags;
    }

    /**
     * @template T extends array<mixed>|LogRecord
     *
     * @param T $record
     *
     * @return T
     *
     * @noinspection AdditionOperationOnArraysInspection
     */
    public function processRecord($record)
    {
        if ($record instanceof LogRecord) {
            $record->extra += $this->tags;

            return $record;
        }
        $record['extra'] += $this->tags;

        return $record;
    }
}
