Unified fixtures is the next iteration of [Better Fixtures](./better-fixtures.md). This simplifies the process and
allows for better fixture dependency across types.

## Configuration
To activate the unified process se the `unified` option to true
```yaml
cyber_deployment:
    fixtures:
        unified: true
```

Once `unified` option is set the original options `standard`, `install`, and `dev` whill play no role in the process.

## Process Chnages
The original process was executing the fixtures command up to 3 separate times (with `--dev` flag) with different group
for each execution. 

The new process run the command a single time but simply passes multiple groups depending on the flag. 

### Example
Let's take for example execution with `--dev` flag. 

Original process:
* Reset DB
* Append fixtures with group `standard`
* Append fixtures with group `install`
* Append fixtures with group `dev`

New process:
* Reset Db
* Append fixtures with groups [`standard`, `install`, `dev`]

As you can see from the example, fixtures from all 3 groups get applied in both cases but in first scenario they are 
applied via 3 separate commands, thus preventing fixtures from different groups from depending on each other.

In the new process all 3 groups are included in a single command so you can setup the dependency across all sets of
fixtures as needed. 

## Upgrading to new process
If you are currently using the original process, you need to keep in mind that new process will run ALL groups together.
As a result the order of fixtures may change. Previously `install` would ALWAYS run after `standard` and `dev` would 
ALWAYS run after `install`. Now they run all together so you might need to explicitly specify the dependncies using the
standard fixtures mechanism if your dev or install fixtures depend on specific standard fixtures.
