<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Tests\Cyber\DeploymentBundle\Migrations;

use Cyber\DeploymentBundle\Migrations\FunctionExtractor;
use PHPUnit\Framework\TestCase;
use UnexpectedValueException;

/**
 * @covers \Cyber\DeploymentBundle\Migrations\FunctionExtractor
 *
 * @internal
 */
class FunctionExtractorTest extends TestCase
{
    public function testGetFunctionData(): void
    {
        $code = <<<EOC
function x()
{
    // some code
}
EOC;

        $instance = new FunctionExtractor($code);

        $data = $instance->getFunctionData(0);
        static::assertEquals('
    // some code', $data);
    }

    public function testNoFunction(): void
    {
        $this->expectException(UnexpectedValueException::class);
        $this->expectExceptionMessage('Failed to find start of function');

        $code = <<<EOC
function x()

    // some code
}
EOC;

        $instance = new FunctionExtractor($code);

        $instance->getFunctionData(0);
    }

    public function testNoEndOfFunction(): void
    {
        $this->expectException(UnexpectedValueException::class);
        $this->expectExceptionMessage('Failed to find end of function');

        $code = <<<EOC
function x()
{
    // some code
    {
    
}
EOC;

        $instance = new FunctionExtractor($code);

        $instance->getFunctionData(0);
    }
}
