<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle;

class MigrationState
{
    /**
     * @param array<int, int[]> $migrationSequence
     * @param int[]             $preDeployVersions
     * @param int[]             $postDeployVersions
     */
    public function __construct(
        private readonly array $migrationSequence,
        private array $preDeployVersions,
        private readonly array $postDeployVersions,
    ) {
    }

    /**
     * @return array<int, int[]>
     */
    public function getSequence(): array
    {
        return $this->migrationSequence;
    }

    /**
     * @return int[]
     */
    public function preDeployVersions(): array
    {
        return $this->preDeployVersions;
    }

    /**
     * @return int[]
     */
    public function postDeployVersions(): array
    {
        return $this->postDeployVersions;
    }

    public function lastSeqVersion(): int
    {
        $sequenceVersions       = \array_keys($this->migrationSequence);

        return (int) \end($sequenceVersions);
    }

    public function lastPreDeployVersion(): int
    {
        return (int) \end($this->preDeployVersions);
    }
}
