<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Tests\Cyber\DeploymentBundle;

use Cyber\DeploymentBundle\MigrationHelpers;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use RuntimeException;

class MockMigrationHelper extends AbstractMigration
{
    use MigrationHelpers;

    protected $connection;

    /**
     * @param \Doctrine\DBAL\Platforms\AbstractPlatform $mockPlatform
     * @param \Doctrine\DBAL\Connection                 $mockConnection
     *
     * @noinspection PhpMissingParentConstructorInspection
     */
    public function __construct($mockPlatform, $mockConnection)
    {
        // disable pass original constructor
        $this->platform   = $mockPlatform;
        $this->connection = $mockConnection;
    }

    /**
     * @inheritDoc
     */
    public function up(Schema $schema): void
    {
        throw new RuntimeException('This should not be calld in this test');
    }

    /**
     * @inheritDoc
     */
    public function down(Schema $schema): void
    {
        throw new RuntimeException('This should not be calld in this test');
    }
}
