Makes fixtures usable not only for development, but also for static data provisioning and new system deployments.

## Configuration

```yaml
cyber_deployment:
    fixtures:
        standard: true # or false
        install: true # or false
        dev: true # or false
        connections:
            - default
            - second
        managers:
            - default
            - second_em
```

This command expects you to assign your fixtures to one of 3 groups `standard`, `install` or `dev` and indicate if you
will you using each of those groups by setting corresponding config value to true or false.

These groups of fixtures will execute based on the arguments passwed to this command.

## Usage

```bash
> php bin/console cyber:deploy:fixtures [--dev|--install]
```

Running this command will always includle fixtures with `standard` if they are enabled. Further more if ran with
`--install` or `--dev` flag additional fixtures will be applied.

* `--install` - adds fixtures with `install` group
* `--dev` - **resets database schema**, applies  `standard`, `install`, and finally fixtures with `dev` group
    * DO NOT RUN THIS ON LIVE DATABASE CONNECTION

> all applicable fixtures are loaded in a single `fixtures:load` sub-command by passing multiple groups to it.

## Install Fixtures

Intended to be ran only once during new live system setup. These fixtures are intended to create some initial
configuration which can then be used to fully configure the application.

Most basic example is to create a `root` user account with known password, when deploying a new application. Then
login with that account, reset password and create additional admin and user accounts.

These are typically ran manually by the individual deploying the new live environment.

## Standard Fixtures

These are intended to maintain managed data in the database. This fixtures are expected to execute during each
deployment and should be written in a way to append data to tables if it is missing and remove stuff that is not needed.

These could be used to maintain application specific enum lists that is not editable by users but should still be
available for convenient database queries (language abbreviation -> language name).

Typical implementation of such fixtures includes a data array and a loop that checks data existence. Then update
existing
and create any missing records.

> Entities of these fixtures typically do not have auto-generated ID, instead it is manually assigned by fixture itself

```php
<?php

private $languages = [
    'en' => 'English',
    'aa' => 'Afar',
];

public function load(ObjectManager $manager)
{
    
    foreach ($this->languages as $code => $name) {
        $entity = $manager->find("CoreAppBundle:Language", $code);
        if ($entity == null) {
            $entity = new Language();
            $entity->setCode($code);
            $manager->persist($entity);
        }
        $entity->setName($name);
    }

    $manager->flush();
}
```

### Shouldn't This Be A Migration?

There is very thin line between the concept of Standard Fixture and migration. Everything that a this fixture does
could be achieved by a migration. The only difference is that migration only ever runs once, while standard fixture
runs on each deply, which allows for different type of controll for how the data is loaded.

## Dev Fixtures

These are the fixtures that you are probably most familiar with. They load fake data into database so that developers
don't have to work with empty database every time they need to reset the schema.

They are applied only command is ran with `--dev` flag.

# Multiplle Connections and EMs

> They only effect the execution with `--dev` flags.

By default when database and schema is being reset, only the default connection and entity manager are being used.
If your application has multiple connections and EMs AND your `dev` fixtures load data into both, you will need
to specify them in the corresponding config array.

Database will be dropped and created from scrach for all listed connections/ems when running the command with `--dev`.

## EM Isolation

When `isolate_managers` is set to true the execution behavior changes as follows:

1. the load command will be executed once per configured manager and the `--em` option will be passed to it
2. in addition to normal groups an anologous group with EM name will be used
    * for example say you have to manager `main` and `other`, then there will be 2 loads with groups
        1. `standard` + `standard_main`
        2. `standard` + `standard_other`
    * and of course if you ran with `--dev` or `--install` then those groups would be added in similar fassion as
      `standard`

This gives you 2 options when writing fixtures, since you will most likely need to know which manager is in play for
each load:

1. Check a desired instance of entity manager against the $manager passed into `load()`
2. Use manager specific group name for your fixture (ex `dev_main` instead of `dev`)

# Events

During execution several events are fired which you can take advantage of to perform additional tasks.

## PreDatabaseResetEvent

An event trigger before database reset.

You can use this to perform any extra cleanups necessary which is not supported by doctinre's default
doctrine:schema:drop command.

> Event is triggered once for each configured entity manager

## PostDatabaseResetEvent

An event trigger after database reset and before fixtures are applied.

You can use this to perform any extra configurations necessary to bring the db to a proper state.

> Event is triggered once for each configured entity manager

## BeforeFixturesAppliedEvent

This event is triggered after all the database schemas have been reset, but before fixtures start loading.

It includes a list of fixture groups that have been executed.

If you have just a single entity manager the timing of this event is equivalent to `PostDatabaseResetEvent`.
In situations with multiple managers unlinke `PostDatabaseResetEvent`s which are triggered after each database,
this event runs only ONCE after all schemas have been updated and right before fixture loading begins.

## FixturesAppliedEvent

This event is triggered after all the fixtures have been applied.

It includes a list of fixture groups that have been executed.

> Regardless of EM isolation level this event is dispatched only once after all fixtures across all EMs have been loaded
> List of groups will contain non EM specific values `standard`, `install` and/or `dev`
