<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\DeploymentBundle;

use Cyber\DeploymentBundle\LogTaggingProcessor;
use Monolog\Handler\HandlerInterface;
use Monolog\Logger;
use Monolog\LogRecord;
use PHPUnit\Framework\TestCase;

/**
 * @internal
 *
 * @covers \Cyber\DeploymentBundle\LogTaggingProcessor
 */
class LogTaggingProcessorTest extends TestCase
{
    /** @var LogTaggingProcessor */
    private $processor;

    /**
     * @inheritDoc
     */
    protected function setUp(): void
    {
        $this->processor = new LogTaggingProcessor(['graylog_tag' => 'dev', 'graylog_site' => 'cyber-collection']);
    }

    public function testProcessRecord(): void
    {
        $record = $this->processor->processRecord(['extra' => []]);
        static::assertEquals(['extra' => ['graylog_tag' => 'dev', 'graylog_site' => 'cyber-collection']], $record);

        // processor should not override a tag if one already exists
        $record = $this->processor->processRecord(['extra' => ['graylog_tag' => 'test-override']]);
        static::assertEquals(
            ['extra' => ['graylog_tag' => 'test-override', 'graylog_site' => 'cyber-collection']],
            $record
        );
    }

    /**
     * @group integration
     */
    public function testWithRealLogger(): void
    {
        $handler = $this->getMockBuilder(HandlerInterface::class)->getMock();
        $handler->expects(static::once())
            ->method('handle')
            ->with(static::callback(function ($record) {
                $data = ($record instanceof LogRecord) ? $record->extra : $record['extra'];
                self::assertEquals(['graylog_tag' => 'dev', 'graylog_site' => 'cyber-collection'], $data);

                return true;
            }));

        $handler->method('isHandling')->willReturn(true);

        $logger = new Logger('my_channel', [$handler], [[$this->processor, 'processRecord']]);

        $logger->info('some message');
    }
}
