<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Cyber\DeploymentBundle\Command\DevFixturesCommand;
use Cyber\DeploymentBundle\Command\MergeMigrationsCommand;
use Cyber\DeploymentBundle\Command\NoDowntimeExecuteCommand;
use Cyber\DeploymentBundle\Command\NoDowntimeUpdateCommand;
use Cyber\DeploymentBundle\Command\NoDowntimeVerifyCommand;
use Cyber\DeploymentBundle\Command\ValidateCommand;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Filesystem\Filesystem;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->services()
        ->set('cyber_deployment.command.fixtures', DevFixturesCommand::class)
            ->args([
                service('cyber_deployment.config'),
                service('cyber_deployment.fixtures.event_producer'),
                service('doctrine')->nullOnInvalid(),
            ])
            ->tag('console.command')
        ->alias(DevFixturesCommand::class, 'cyber_deployment.command.fixtures')

        ->set('cyber_deployment.command.merge_migrations', MergeMigrationsCommand::class)
            ->args([
                service('cyber_deployment.config'),
                service(Filesystem::class),
                service('doctrine_migrations.configuration')->nullOnInvalid(),
            ])
            ->tag('console.command')
        ->alias(MergeMigrationsCommand::class, 'cyber_deployment.command.merge_migrations')

        ->set('cyber_deployment.command.validate', ValidateCommand::class)
            ->args([
                service('cyber_deployment.config'),
                service(EntityManagerInterface::class),
            ])
            ->tag('console.command')
        ->alias(ValidateCommand::class, 'cyber_deployment.command.validate')

        ->set('cyber_deployment.command.no_downtime.execute', NoDowntimeExecuteCommand::class)
            ->args([
                service('cyber_deployment.config'),
            ])
            ->tag('console.command')
        ->alias(NoDowntimeExecuteCommand::class, 'cyber_deployment.command.no_downtime.execute')

        ->set('cyber_deployment.command.no_downtime.update', NoDowntimeUpdateCommand::class)
            ->args([
                service('cyber_deployment.config'),
            ])
            ->tag('console.command')
        ->alias(NoDowntimeUpdateCommand::class, 'cyber_deployment.command.no_downtime.update')

        ->set('cyber_deployment.command.no_downtime.verify', NoDowntimeVerifyCommand::class)
            ->args([
                service('cyber_deployment.config'),
            ])
            ->tag('console.command')
        ->alias(NoDowntimeVerifyCommand::class, 'cyber_deployment.command.no_downtime.verify')
    ;
    // @formatter:on
};
